// OpenLine4.cpp: implementation of the COpenLine4 class.
//------------------------------------------------------------------
// !!!WARNING!!!
//------------------------------------------------------------------
//	This class was developed for use in this sample application only
//	It does not contain ALL functions supported by hardware
//	For the full API please refer to C interface and documentation
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "OpenLine4 demo.h"
#include "OpenLine4.h"


#include "api/verbose.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// Maximum Channel num
#define MAX_CH		4
// Maximum Card num
#define MAX_CN		2   // Can be more. Not sure what exact limit 

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COpenLine4::COpenLine4()
{
	m_Handle = -1;
	m_CardNum = 0;
	m_ChannelNum = 0;
	m_HookState = FALSE; // TRUE = HOOK_ON
	m_LastErrorCode = 0;
	m_IsRecording = FALSE;
	m_IsPlaying = FALSE;
	m_EventCallback = NULL;
	m_IsBusy = FALSE;
}

COpenLine4::~COpenLine4()
{

}

int COpenLine4::InitVPB(unsigned int CardNum, unsigned int ChannelNum)
{
	// Set errors handling mode
	vpb_seterrormode(VPB_EXCEPTION);

	try
	{
		m_Handle = vpb_open(CardNum, ChannelNum);
	}
	catch (VpbException v) {
		m_LastErrorCode = v.code;
        return 0;
	}
	
	vpb_set_event_callback(m_Handle, event_callback, this);

	m_CardNum = CardNum;
	m_ChannelNum = ChannelNum;

	return 1;

}

bool COpenLine4::ShutDownVPB()
{
	try
	{
		// Misc sleeps here are empirical
		// to avoid Access Violation in driver on shutdown

		// Stop playing
		StopPlay();
		// Stop recording
		StopRecord();
		// Wait for recording/playing termination
		while(m_IsRecording || m_IsPlaying || m_IsBusy)
		{
			Sleep(100);
		}

		// Remove callback
		vpb_set_event_callback(m_Handle, NULL, NULL);
		
		Sleep(100);
		// Close channel
		vpb_close(m_Handle);
		m_Handle = -1;
	}
	catch (VpbException v) {
		m_LastErrorCode = v.code;
        return false;
	}

	return true;
}


int COpenLine4::GetLastError()
{
	return m_LastErrorCode;
}

bool COpenLine4::GetHookState()
{
	return m_HookState;
}

unsigned int COpenLine4::GetChannelNum()
{
	return m_ChannelNum;
}

COpenLine4::SwitchHook()
{
	if (m_Handle<0) return 0;

	m_HookState = !m_HookState;
	try
	{
		vpb_sethook_sync(m_Handle, m_HookState);
	}
	catch (VpbException v) 
	{
		m_LastErrorCode = v.code;
		// Hook state not changed
		m_HookState = !m_HookState;
        return 0;
	}
	return 1;
}

bool COpenLine4::GetEventAsync(VPB_EVENT &e)
{
	return (vpb_get_event_ch_async(m_Handle, &e) == VPB_OK);
}

bool COpenLine4::GetEventDescAsync(CString &str)
{
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];
	if (GetEventAsync(e))
	{
		vpb_translate_event(&e,s);
		str.Empty(); 
		str.Insert(0,s); 
		return true;
	}
	return false;
}

// Record wav file

bool COpenLine4::RecordFile(CString sFileName)
{
	if (m_Handle<0) return 0;

	// if recording in progress exit
	if (m_IsRecording) return false;

	char szFileName[255]="";
	lstrcpy(szFileName,(LPCTSTR)sFileName);
	try
	{
		vpb_record_file_async(m_Handle, szFileName, VPB_ALAW);
	}
		catch (VpbException v) {
		m_LastErrorCode = v.code;
        return false;
	}
	m_IsRecording = TRUE;
	return true;
}

//

bool COpenLine4::PlayFile(CString sFileName)
{
	if (m_Handle<0) return false;

	// if playing in progress exit
	if (m_IsPlaying) return false;

	char szFileName[255]="";
	lstrcpy(szFileName,(LPCTSTR)sFileName);
	try
	{
		vpb_play_file_async(m_Handle, szFileName, 0);
	}
		catch (VpbException v) {
		m_LastErrorCode = v.code;
        return false;
	}
	m_IsPlaying = TRUE;
	return true;
}

COpenLine4::StopRecord()
{
	if (m_Handle<0) return 0;
	if (m_IsRecording)
	{
		vpb_record_terminate(m_Handle);
		m_IsRecording = FALSE;
		return 1;
	}
	
	return 0;
}
COpenLine4::StopPlay()
{
	if (m_Handle<0) return 0;
	if (m_IsPlaying)
	{
		vpb_play_terminate(m_Handle);
		m_IsPlaying = FALSE;
		return 1;
	}

	return 0;
}

bool COpenLine4::Call(CString sNumber)
{
//	if (m_HookState) return false;
	if (m_Handle<0) return false;

	char szNum[255]="";
	
	try
	{
		lstrcpy(szNum,(LPCTSTR)sNumber);
		vpb_dial_sync(m_Handle, szNum);
	}
	catch (VpbException v) {
		m_LastErrorCode = v.code;
        return false;
	}

	return true;
}

void WINAPI COpenLine4::event_callback(VPB_EVENT *e, void *context)
 {

	// Get class pointer
	COpenLine4* pThis = (COpenLine4*)context;

	pThis->m_IsBusy = TRUE;
	// Handle some important event here and pass to the external handler if defined
	switch (e->type )
	{

	case VPB_RECORDEND: pThis->m_IsRecording = FALSE; break;
	case VPB_PLAYEND: pThis->m_IsPlaying = FALSE; break;

	}

	if (pThis->m_EventCallback)
	{
		pThis->m_EventCallback(e,context);
	}

	pThis->m_IsBusy = FALSE;
 }



int COpenLine4::SetCallback(void (__stdcall *event_callback)(VPB_EVENT *,void *), void *context)
{
	
	// Assign event callback
	m_EventCallback = event_callback;

	//return vpb_set_event_callback(m_Handle, event_callback, context);
	return 1;
}


bool COpenLine4::IsRecording()
{
	return m_IsRecording;
}

bool COpenLine4::IsPlaying()
{
	return m_IsPlaying;
}
